﻿namespace MCalcConsole
{
    internal class StackEntriesConsole : StackEntries
    {
        public int TrimToLength(int newlength, int lastBufferLine)
        {
            int j = this.Count;
            if (newlength < 0 || newlength > j)
                throw new Exception("incorrect stack length to trim");
            if (newlength == 0)
            {
                this.Clear();
                this.Values.Clear();
                Console.Clear();
                return -1;
            }
            while (newlength < j)
            {
                if(lastBufferLine >= 0)
                {
                    Program.ClearLine(lastBufferLine);
                }
                lastBufferLine--;
                j--;
                this.RemoveAt(j);
                this.Values.Remove(j);
            }
            return lastBufferLine;
        }

        public void AddToStack(StackEntry rse, double? result, int atBufferLine)
        {
            int j = this.Count;
            this.Add(rse);
            rse.AR = Convert(j % CMod);
            if (rse.AR != null && rse.AR.Length >= Program.layout_indices[1])
            {
                Console.Write(rse.AR.Substring(0, Program.layout_indices[1]));
            }
            else
            {
                Console.Write(rse.AR);
            }
            Console.CursorLeft = Program.layout_indices[1];
            int jl = Program.layout_indices[2] - Program.layout_indices[1];
            if(rse.TypedEntry != null && rse.TypedEntry.Length >= jl)
                Console.Write(rse.TypedEntry.Substring(0, jl - 1));
            else
                Console.Write(rse.TypedEntry);
            Console.CursorLeft = Program.layout_indices[2];
            if(rse is ErrorSE)
            {
                jl = Program.layout_indices[4] - Program.layout_indices[2];
                if (rse.Comment != null && rse.Comment.Length >= jl)
                    Console.WriteLine(rse.Comment.Substring(0, jl - 1));
                else
                    Console.WriteLine(rse.Comment);
            }
            else
            {
                if (result != null)
                {
                    Console.Write(result.ToString());
                    this.Values.Add(this.Count - 1, result.Value);
                }
                Console.CursorLeft = Program.layout_indices[3];
                jl = Program.layout_indices[4] - Program.layout_indices[3];
                if (rse.Comment != null && rse.Comment.Length >= jl)
                    Console.WriteLine(rse.Comment.Substring(0, jl - 1));
                else
                    Console.WriteLine(rse.Comment);
            }
        }
    }
}
