﻿namespace MCalcConsole
{
    internal class Parser
    {
        internal required StackEntries myStack;

        public enum EntryType { Cmd, Num, Com, Ref, Start, Unknown };

        const string nschars = "+-", rschars = "{_'`\"&:!#$}", cschars = "~<>%^@?*+-/|\\";
        public const char comchar = ' ', dpchar = '.';

        public StackEntry ParseInput(string input)
        {
            if (input.Length < 1)
            {
                /*if(myStack.Count > 0)
                {
                    string? i = myStack.Last().TypedEntry;
                    if (i == null || i.Length < 1)
                        return new CommentSE() { Comment = "", TypedEntry = "" };
                    input = i;
                }
                else*/
                    return new InputCommand() { cmdword = "b", TypedEntry = "" };
            }
            int j = input.IndexOf(comchar);
            string? com = null;
            string inc;
            if (j != -1)
            {
                if (j == 0)
                {
                    return new CommentSE() { Comment = input.Substring(1), TypedEntry = input };
                }
                com = input.Substring(j + 1);
                inc = input.Substring(0, j);
            }
            else
            {
                inc = input;
            }
            EntryType t = TestInputStart(inc);
            StackEntry? rt = null;
            List<StackReference>? rs = null;            
            switch (t)
            {
                case EntryType.Num:
                    /*int q = inc.IndexOf('/');
                    if (q != -1)
                    {
                        string[] dd = inc.Split('/');
                        if (dd.Length != 2)
                            throw new Exception("Not sure how to interpret division entry");
                        rt = new ValueSE() { Result = double.Parse(dd[0]) / double.Parse(dd[1]) };
                    }
                    else
                    {
                        rt = new ValueSE() { Result = double.Parse(inc) };
                    }*/
                    double v = double.Parse(inc);
                    //val = v;
                    rt = new ValueSE() { value = v };
                    break;
                case EntryType.Cmd:
                    rt = GetCommandSE(inc, null);
                    break;
                case EntryType.Ref:
                    (rs, inc) = GetRefs(inc);
                    rt = GetCommandSE(inc, rs);
                    break;
            }
            if (rt == null)
                throw new ArgumentException("Could not determine how to interpret input");
            rt.TypedEntry = input;
            rt.Comment = com;
            return rt;
        }

        private InputCommand GetCommandSE(string cmw, List<StackReference>? refs)
        {
            int pr = 0;// (refs == null) ? 0 : refs.Count;
            if (cmw.Length < 1)
            {
                throw new Exception("Command word empty string");
            }
            string? sr = null;
            if (cmw.StartsWith(Processor.ve_cmd))
            {
                sr = cmw.Substring(Processor.ve_cmd.Length);
                cmw = Processor.ve_cmd;
            }
            if (cmw.StartsWith(Processor.vq_cmd))
            {
                sr = cmw.Substring(Processor.vq_cmd.Length);
                cmw = Processor.vq_cmd;
            }
            if (sr != null)
            {
                List<StackReference>? ar = null;
                (ar, sr) = GetRefs(sr);
                if (sr.Length > 0)
                {
                    throw new ArgumentException("Unknown end of command");
                }
                if (ar == null || ar.Count < 2)
                    throw new ArgumentException("Incorrect format for " + cmw + " command");
                pr = ar.Count;
                if (refs == null)
                    refs = new List<StackReference>();
                refs.AddRange(ar);
            }

            return new InputCommand() { cmdword = cmw, cmdrefs = refs, prefs = pr };
        }

        private (List<StackReference>?,string rmnd) GetRefs(string s)
        {
            if (s.Length < 1)
                return (null, s);
            bool iteratorContext = false, rangeContext = false, multiCContext = false;
            int ict = 0, irem = -1;
            List<StackReference> srl = new List<StackReference>();
            SRIterator? sri = null;
            SRSingle? rangeStart = null, rangeEnd = null;
            for(int i=0; i<s.Length; i++)
            {
                if (s[i] == '{')
                {
                    if (iteratorContext || multiCContext)
                        throw new ArgumentException("Incorrect iterator definition start");
                    if (rangeContext)
                    {
                        rangeEnd = myStack.GetRefByRelativeIndex(1);
                        srl.AddRange(GenerateRange(rangeStart, rangeEnd));
                        rangeContext = false;
                    }
                    iteratorContext = true;
                    sri = new SRIterator();
                    continue;
                }
                if (s[i] == '}')
                {
                    if (sri == null || (!iteratorContext) || multiCContext)
                        throw new ArgumentException("Incorrect iterator definition end");
                    if (rangeContext)
                    {
                        rangeEnd = myStack.GetRefByRelativeIndex(1);
                        sri.refs.AddRange(GenerateRange(rangeStart, rangeEnd));
                        rangeContext = false;
                    }
                    if (sri.refs.Count < 1)
                    {
                        (rangeStart, rangeEnd) = myStack.GetLastIterator();
                        sri.refs.AddRange(GenerateRange(rangeStart, rangeEnd));
                    }
                    srl.Add(sri);
                    sri = null;
                    iteratorContext = false;
                    continue;
                }
                if (s[i] == '_')
                {
                    if(rangeContext || multiCContext)
                        throw new ArgumentException("Incorrect range definition");
                    rangeContext = true;
                    if ((i == 0) || s[i - 1] == '{' || s[i - 1] == '}')
                    {
                        rangeStart = myStack.GetRefByRelativeIndex(1);
                    }
                    else
                    {
                        if (iteratorContext)
                        {
                            if (sri.refs.Count > 0)
                            {
                                SRSingle a = sri.refs[sri.refs.Count - 1];
                                rangeStart = a;
                                sri.refs.RemoveAt(sri.refs.Count - 1);
                            }
                            else
                            {
                                if (myStack.Count < 1)
                                    throw new Exception("There is nothing to reference 2");
                                rangeStart = myStack.GetRefByRelativeIndex(1);
                            }
                        }
                        else
                        {
                            if (srl.Count > 0)
                            {
                                StackReference a = srl[srl.Count - 1];
                                if (a is not SRSingle)
                                    throw new Exception("Improper range definition");
                                rangeStart = (SRSingle)a;
                                srl.RemoveAt(srl.Count - 1);
                            }
                            else
                            {
                                if (myStack.Count < 1)
                                    throw new Exception("There is nothing to reference");
                                rangeStart = myStack.GetRefByRelativeIndex(1);
                            }
                        }
                    }
                    continue;
                }
                List<SRSingle>? completer = null;
                if (s[i] == '\"')
                {
                    //get references of last command
                    CommandSE cse = (CommandSE)myStack.GetByRef(myStack.GetLastCommand());
                    if (cse.cmdrefs != null)
                    {
                        completer = new List<SRSingle>();
                        completer.AddRange(cse.cmdrefs);
                    }
                }
                if (s[i] == ':')
                {
                    (SRSingle,SRSingle) sre = myStack.GetLastMultiline();
                    completer = GenerateRange(sre.Item1, sre.Item2);
                }
                if (s[i] == '&')
                {
                    (SRSingle, SRSingle) sre = myStack.GetLastIterator();
                    completer = GenerateRange(sre.Item1, sre.Item2);
                }
                if (completer != null)
                {
                    if (multiCContext)
                        throw new ArgumentException("Incorrect ref definition 5");
                    if (rangeContext)
                    {
                        List<SRSingle> s1 = GenerateRange(rangeStart, completer[0]);
                        if(s1.Count > 0)
                        {
                            s1.RemoveAt(s1.Count - 1);
                        }
                        s1.AddRange(completer);
                        if (iteratorContext)
                        {
                            sri.refs.AddRange(s1);
                        }
                        else
                        {
                            srl.AddRange(s1);
                        }
                        rangeContext = false;
                    }
                    else
                    {
                        if (iteratorContext)
                        {
                            sri.refs.AddRange(completer);
                        }
                        else
                        {
                            srl.AddRange(completer);
                        }
                    }
                    continue;
                }
                if (s[i] == '\'')
                {
                    //append last or second to last reference or swap
                    if (multiCContext || rangeContext || iteratorContext)
                        throw new ArgumentException("Incorrect reference swap");
                    int sc = srl.Count;
                    if(sc < 2)
                    {
                        srl.Add(myStack.GetRefByRelativeIndex(1));
                        if (sc < 1)
                        {
                            srl.Add(myStack.GetRefByRelativeIndex(2));
                        }
                    }
                    else
                    {
                        StackReference ssr = srl[sc - 2];
                        srl.RemoveAt(sc - 2);
                        srl.Add(ssr);
                    }
                    continue;
                }
                SRSingle? ss = null;
                if (s[i] >= 'A' && s[i] <= 'Z')
                {
                    if (multiCContext)
                    {
                        multiCContext = false;
                    }
                    else
                    {
                        ict = 0;
                    }
                    ss = myStack.GetRefByCIndex(ict, s[i]);
                }
                if (s[i] == '`')
                {
                    if (multiCContext)
                    {
                        ict++;
                    }
                    else
                    {
                        ict = 1;
                        multiCContext = true;
                    }
                    continue;
                }
                if (ss == null)
                {
                    switch (s[i]) //!#$
                    {
                        case '!': //location of last command
                            ss = myStack.GetLastCommand();
                            break;
                        case '#': //location of last number
                            ss = myStack.GetLastValue();
                            break;
                        case '$': //location of last adj number
                            ss = myStack.GetLastAdjValue();
                            break;
                    }
                }
                if (ss != null)
                {
                    if (multiCContext)
                        throw new ArgumentException("Incorrect ending to reference");
                    if (iteratorContext)
                    {
                        if (rangeContext)
                        {
                            rangeEnd = ss;
                            sri.refs.AddRange(GenerateRange(rangeStart, rangeEnd));
                            rangeContext = false;
                        }
                        else
                        {
                            sri.refs.Add(ss);
                        }
                    }
                    else
                    {
                        if (rangeContext)
                        {
                            rangeEnd = ss;
                            srl.AddRange(GenerateRange(rangeStart, rangeEnd));
                            rangeContext = false;
                        }
                        else
                        {
                            srl.Add(ss);
                        }
                    }
                }
                else
                {
                    irem = i;
                    break; //unknown character encountered
                }
            }
            if (multiCContext || iteratorContext)
                throw new ArgumentException("Incorrect range definition end");
            if (rangeContext)
            {
                rangeEnd = myStack.GetRefByRelativeIndex(1);
                srl.AddRange(GenerateRange(rangeStart, rangeEnd));
                rangeContext = false;
            }
            if (irem == -1)
            {
                return (srl, "");
            }
            else
            {
                return (srl, s.Substring(irem));
            }
        }

        private List<SRSingle> GenerateRange(SRSingle rangeStart, SRSingle rangeEnd)
        {
            int dj = (rangeEnd.stackIndex < rangeStart.stackIndex) ? -1 : 1;
            int ne = dj * (rangeEnd.stackIndex - rangeStart.stackIndex);
            int ds = rangeStart.stackIndex;
            List<SRSingle> srl = new List<SRSingle>();
            while (ne >= 0)
            {
                srl.Add(new SRSingle() { stackIndex = ds });
                ds += dj;
                ne--;
            }
            return srl;
        }

        public static EntryType TestInputStart(string s)
        {
            if (string.IsNullOrEmpty(s))
                return EntryType.Unknown;
            if (s[0] == comchar)
                return EntryType.Com;
            if (s[0] == dpchar || char.IsAsciiDigit(s[0]))
                return EntryType.Num;
            if (char.IsAsciiLetterLower(s[0]))
                return EntryType.Cmd;
            if (char.IsAsciiLetterUpper(s[0]))
                return EntryType.Ref;
            if (rschars.Contains(s[0]))
                return EntryType.Ref;
            bool cnamb = nschars.Contains(s[0]);
            if (cschars.Contains(s[0]) && !cnamb)
                return EntryType.Cmd;
            if (!cnamb)
                return EntryType.Unknown;
            if (s.Length > 1 && (char.IsAsciiDigit(s[1]) || s[1] == dpchar))
                return EntryType.Num;
            else
                return EntryType.Cmd;
        }
    }
}
