﻿namespace MCalcConsole
{
    internal class ExtCmdManager
    {
        public SortedSet<string> AvailableCommands = new SortedSet<string>();
        public SortedList<string, ExtCmdProps> LoadedCommands = new SortedList<string, ExtCmdProps>();
        public string ExtCmdsDir = "./extcmds";

        public ExtCmdManager()
        {
            if (!Directory.Exists(ExtCmdsDir))
                return;
            IEnumerable<string> fls = Directory.EnumerateFiles(ExtCmdsDir, "*.txt");
            foreach(string fn in fls)
            {
                string f = Path.GetFileNameWithoutExtension(fn);
                bool v = f.Length > 0;
                for(int i=0; i<f.Length; i++)
                {
                    if (f[i] < 'a' || f[i] > 'z')
                    {
                        if (!(f[i] >= '0' && f[i] <= '9' && i > 0))
                        {
                            v = false;
                            break;
                        }
                    }
                }
                if (v)
                {
                    AvailableCommands.Add(f);
                }
            }
        }

        public void LoadCommand(string cmd, Processor ps)
        {
            string fn = Path.Combine(ExtCmdsDir, cmd + ".txt");
            string[] clines = File.ReadAllLines(fn);
            StackEntries cmdStack = new StackEntries();
            //List<int> inputInds = new List<int>();
            //List<int> outputInds = new List<int>();
            Parser myParser = new Parser() { myStack = cmdStack };
            int il = 0, ol = 0;
            for (int i=0; i<clines.Length; i++)
            {
                StackEntry se = myParser.ParseInput(clines[i]);
                if (se is InputCommand) {
                    InputCommand cse = ((InputCommand)se);
                    if(cse.cmdword == Processor.ve_cmd || cse.cmdword == Processor.vc_cmd || cse.cmdword == Processor.vq_cmd)
                        throw new Exception(cse.cmdword + " command in external commands is not supported");
                    List<CommandSE> upc = ps.UnpackInput(cse, cmdStack, i);
                    if(upc.Count > 1)
                        throw new Exception("Iterators and multilines in external commands not supported");
                    if (upc.Count == 0)
                        throw new Exception("Could not unpack external command line (?)");
                    CommandSE cse2 = upc[0];
                    se = cse2;
                    if (cse2.cmdword == Processor.ei_cmd)
                    {
                        //inputInds.Add(i);
                        il++;
                    }
                    if (cse2.cmdword == Processor.eo_cmd)
                    {
                        if (cse2.cmdrefs == null || cse2.cmdrefs.Count < 1)
                            throw new Exception("out command not unpacked (should never see this)");
                        else
                            ol += cse2.cmdrefs.Count;
                        /*foreach(SRSingle srs in cse2.cmdrefs)
                        {
                            outputInds.Add(srs.stackIndex);
                        }*/
                        //se = new CommentSE(); //placeholder for non-referencing output command
                    }
                }
                /*if(se is ValueSE)//this will be called again when running the stack
                {
                    cmdStack.Values[i] = ((ValueSE)se).value;
                }*/
                cmdStack.AddToStack(se);
            }
            if (ol < 1)
                throw new Exception("External command produces no outputs");
            ExtCmdProps ecp = new ExtCmdProps() { inlines = il, outlines = ol, myStack = cmdStack };
            LoadedCommands.Add(cmd, ecp);
        }
    }

    internal class ExtCmdProps
    {
        //internal delegate double[] ComputeResult(List<double> args);
        required public int inlines, outlines;
        required public StackEntries myStack;
        //required public List<int> inInds, outInds;
        //required public ComputeResult cmdfunc;
    }
}
