﻿namespace MCalcConsole
{
    internal class StackEntriesConsole : StackEntries
    {
        public int TrimToLength(int newlength, int lastBufferLine)
        {
            int j = this.Count;
            if (newlength < 0 || newlength > j)
                throw new Exception("incorrect stack length to trim");
            if (newlength == 0)
            {
                this.Clear();
                stackAbsRefInd.Clear();
                Console.Clear();
                return -1;
            }
            bool ra = false;
            while (newlength < j)
            {
                if(lastBufferLine >= 0)
                {
                    Program.ClearLine(lastBufferLine);
                }
                lastBufferLine--;
                j--;
                if (this[j] is RenumberSE)
                {
                    stackAbsRefInd.Pop();
                    ra = true;
                }
                this.RemoveAt(j);
            }
            if(ra)
                RenumberStack(lastBufferLine);
            return lastBufferLine;
        }

        public void AddToStack(StackEntry rse, int atBufferLine)
        {
            int j = this.Count + 1;
            this.Add(rse);
            if (rse is RenumberSE)
            {
                
                stackAbsRefInd.Push(((RenumberSE)rse).newStart);
                RenumberStack(atBufferLine);
            }
            else
            {
                j -= (stackAbsRefInd.Count == 0) ? 0 : stackAbsRefInd.Peek();
                rse.AR = Convert(j);
            }
            if (rse.AR != null && rse.AR.Length > Program.layout_indices[1])
            {
                Console.Write(rse.AR.Substring(0, Program.layout_indices[1]));
            }
            else
            {
                Console.Write(rse.AR);
            }
            Console.CursorLeft = Program.layout_indices[1];
            int jl = Program.layout_indices[2] - Program.layout_indices[1];
            if(rse.TypedEntry != null && rse.TypedEntry.Length >= jl)
                Console.Write(rse.TypedEntry.Substring(0, jl - 1));
            else
                Console.Write(rse.TypedEntry);
            Console.CursorLeft = Program.layout_indices[2];
            if(rse is ErrorSE)
            {
                jl = Program.layout_indices[4] - Program.layout_indices[2];
                if (rse.Comment != null && rse.Comment.Length > jl)
                    Console.WriteLine(rse.Comment.Substring(0, jl));
                else
                    Console.WriteLine(rse.Comment);
            }
            else
            {
                if (rse.Result != null)
                    Console.Write(rse.Result.ToString());
                Console.CursorLeft = Program.layout_indices[3];
                jl = Program.layout_indices[4] - Program.layout_indices[3];
                if (rse.Comment != null && rse.Comment.Length > jl)
                    Console.WriteLine(rse.Comment.Substring(0, jl));
                else
                    Console.WriteLine(rse.Comment);
            }
        }

        private void RenumberStack(int lastBufferLine)
        {
            int j = stackAbsRefInd.Count == 0 ? 0 : stackAbsRefInd.Peek();
            int k = this.Count;
            int wl = lastBufferLine - (k - j) + 1;
            for (int i = j; i < k; i++)
            {
                int a = i - j;
                this[i].AR = Convert(a + 1);
                if (wl >= 0)
                {
                    Console.SetCursorPosition(0, wl);
                    if (this[i].AR != null && this[i].AR.Length > Program.layout_indices[1])
                    {
                        Console.Write(this[i].AR.Substring(0, Program.layout_indices[1]));
                    }
                    else
                    {
                        Console.Write(this[i].AR);
                    }
                    for (int o = this[i].AR.Length; o < Program.layout_indices[1]; o++)
                        Console.Write(' ');
                }
                wl++;
            }
        }
    }
}
