﻿namespace MCalcConsole
{
    internal class Parser
    {
        internal required StackEntries myStack;

        public enum EntryType { Cmd, Num, Com, Ref, Start, Unknown };

        const string nschars = "+-", rschars = "{_\"&:!#$}", cschars = "~<>%^@*+-/|\'\\", eechars = "eE";
        public const char comchar = ' ', dpchar = '.';

        public StackEntry ParseInput(string input)
        {
            if (input.Length < 1)
            {
                /*if(myStack.Count > 0)
                {
                    string? i = myStack.Last().TypedEntry;
                    if (i == null || i.Length < 1)
                        return new CommentSE() { Comment = "", TypedEntry = "" };
                    input = i;
                }
                else*/
                    return new InputCommand() { cmdword = "b", TypedEntry = "" };
            }
            int j = input.IndexOf(comchar);
            string? com = null;
            string inc;
            if (j != -1)
            {
                if (j == 0)
                {
                    return new CommentSE() { Comment = input.Substring(1), TypedEntry = input };
                }
                com = input.Substring(j + 1);
                inc = input.Substring(0, j);
            }
            else
            {
                inc = input;
            }
            EntryType t = TestInputStart(inc);
            StackEntry? rt = null;
            List<StackReference>? rs = null;            
            switch (t)
            {
                case EntryType.Num:
                    /*int q = inc.IndexOf('/');
                    if (q != -1)
                    {
                        string[] dd = inc.Split('/');
                        if (dd.Length != 2)
                            throw new Exception("Not sure how to interpret division entry");
                        rt = new ValueSE() { Result = double.Parse(dd[0]) / double.Parse(dd[1]) };
                    }
                    else
                    {
                        rt = new ValueSE() { Result = double.Parse(inc) };
                    }*/
                    rt = new ValueSE() { Result = double.Parse(inc) };
                    break;
                case EntryType.Cmd:
                    rt = GetCommandSE(inc, null);
                    break;
                case EntryType.Ref:
                    (rs, inc) = GetRefs(inc);
                    rt = GetCommandSE(inc, rs);
                    break;
            }
            if (rt == null)
                throw new ArgumentException("Could not determine how to interpret input");
            rt.TypedEntry = input;
            rt.Comment = com;
            return rt;
        }

        private InputCommand GetCommandSE(string cmw, List<StackReference>? refs)
        {
            int pr = (refs == null) ? 0 : refs.Count;
            if (cmw.Length < 1)
            {
                throw new Exception("Command word empty string");
            }
            if (cmw.StartsWith(Processor.ve_cmd))
            {
                string sr = cmw.Substring(Processor.ve_cmd.Length);
                List<StackReference>? ar = null;
                (ar, sr) = GetRefs(sr);
                if (sr.Length > 0)
                {
                    throw new ArgumentException("Unknown end of command");
                }
                if (ar == null || ar.Count < 2)
                    throw new ArgumentException("Incorrect format for " + Processor.ve_cmd + " command");
                if (refs == null)
                    refs = new List<StackReference>();
                refs.AddRange(ar);
                cmw = Processor.ve_cmd;
            }

            return new InputCommand() { cmdword = cmw, cmdrefs = refs, prefs = pr };
        }

        private (List<StackReference>?,string rmnd) GetRefs(string s)
        {
            if (s.Length < 1)
                return (null, s);
            bool iteratorContext = false, rangeContext = false, multiAContext = false, multiRContext = false;
            int ict = 0, irem = -1;
            List<StackReference> srl = new List<StackReference>();
            SRIterator? sri = null;
            SRSingle? rangeStart = null, rangeEnd = null;
            for(int i=0; i<s.Length; i++)
            {
                if (s[i] == '{')
                {
                    if (iteratorContext || multiAContext || multiRContext)
                        throw new ArgumentException("Incorrect iterator definition start");
                    if (rangeContext)
                    {
                        rangeEnd = myStack.GetRefByRelativeIndex(1);
                        srl.AddRange(GenerateRange(rangeStart, rangeEnd));
                        rangeContext = false;
                    }
                    iteratorContext = true;
                    sri = new SRIterator();
                    continue;
                }
                if (s[i] == '}')
                {
                    if (sri == null || (!iteratorContext) || multiAContext || multiRContext)
                        throw new ArgumentException("Incorrect iterator definition end");
                    if (rangeContext)
                    {
                        rangeEnd = myStack.GetRefByRelativeIndex(1);
                        sri.refs.AddRange(GenerateRange(rangeStart, rangeEnd));
                        rangeContext = false;
                    }
                    if (sri.refs.Count < 1)
                    {
                        (rangeStart, rangeEnd) = myStack.GetLastIterator();
                        sri.refs.AddRange(GenerateRange(rangeStart, rangeEnd));
                    }
                    srl.Add(sri);
                    sri = null;
                    iteratorContext = false;
                    continue;
                }
                if (s[i] == '_')
                {
                    if(rangeContext || multiAContext || multiRContext)
                        throw new ArgumentException("Incorrect range definition");
                    rangeContext = true;
                    if ((i == 0) || s[i - 1] == '{' || s[i - 1] == '}')
                    {
                        rangeStart = myStack.GetRefByRelativeIndex(1);
                    }
                    else
                    {
                        if (iteratorContext)
                        {
                            if (sri.refs.Count > 0)
                            {
                                SRSingle a = sri.refs[sri.refs.Count - 1];
                                rangeStart = a;
                                sri.refs.RemoveAt(sri.refs.Count - 1);
                            }
                            else
                            {
                                if (myStack.Count < 1)
                                    throw new Exception("There is nothing to reference 2");
                                rangeStart = myStack.GetRefByRelativeIndex(1);
                            }
                        }
                        else
                        {
                            if (srl.Count > 0)
                            {
                                StackReference a = srl[srl.Count - 1];
                                if (a is not SRSingle)
                                    throw new Exception("Improper range definition");
                                rangeStart = (SRSingle)a;
                                srl.RemoveAt(srl.Count - 1);
                            }
                            else
                            {
                                if (myStack.Count < 1)
                                    throw new Exception("There is nothing to reference");
                                rangeStart = myStack.GetRefByRelativeIndex(1);
                            }
                        }
                    }
                    continue;
                }
                SRSingle? ss = null;
                List<SRSingle>? completer = null;
                if (s[i] == '\"')
                {
                    //get references of last command
                    CommandSE cse = (CommandSE)myStack.GetByRef(myStack.GetLastCommand());
                    if (cse.cmdrefs != null)
                    {
                        completer = new List<SRSingle>();
                        completer.AddRange(cse.cmdrefs);
                    }
                }
                if (s[i] == ':')
                {
                    (ss, rangeEnd) = myStack.GetLastMultiline();
                    completer = GenerateRange(ss, rangeEnd);
                }
                if (s[i] == '&')
                {
                    (ss, rangeEnd) = myStack.GetLastIterator();
                    completer = GenerateRange(ss, rangeEnd);
                }
                if (completer != null)
                {
                    if (multiAContext || multiRContext)
                        throw new ArgumentException("Incorrect ref definition 5");
                    if (rangeContext)
                    {
                        List<SRSingle> s1 = GenerateRange(rangeStart, completer[0]);
                        if(s1.Count > 0)
                        {
                            s1.RemoveAt(s1.Count - 1);
                        }
                        s1.AddRange(completer);
                        if (iteratorContext)
                        {
                            sri.refs.AddRange(s1);
                        }
                        else
                        {
                            srl.AddRange(s1);
                        }
                        rangeContext = false;
                    }
                    else
                    {
                        if (iteratorContext)
                        {
                            sri.refs.AddRange(completer);
                        }
                        else
                        {
                            srl.AddRange(completer);
                        }
                    }
                    continue;
                }
                if (s[i] >= 'A' && s[i] <= 'Z')
                {
                    if(multiRContext)
                        throw new Exception("Incorrect relative end");
                    if (s[i] == 'A')
                    {
                        if (multiAContext)
                        {
                            ict += 25;
                        }
                        else
                        {
                            ict = 25;
                            multiAContext = true;
                        }
                        continue;
                    }
                    else
                    {
                        if (multiAContext)
                        {
                            ict += ('Z' - s[i] + 1);
                            multiAContext = false;
                        }
                        else
                        {
                            ict = ('Z' - s[i] + 1);
                        }
                        ss = myStack.GetRefByAbsoluteIndex(ict);
                    }
                }
                if (s[i] >= '0' && s[i] <= '9')
                {
                    if (multiAContext)
                        throw new Exception("Incorrect relative end");
                    if (s[i] == '0')
                    {
                        if (multiRContext)
                        {
                            ict += 9;
                        }
                        else
                        {
                            ict = 9;
                            multiRContext = true;
                        }
                        continue;
                    }
                    else
                    {
                        if (multiRContext)
                        {
                            ict += (s[i] - '0');
                            multiRContext = false;
                        }
                        else
                        {
                            ict = (s[i] - '0');
                        }
                        ss = myStack.GetRefByRelativeIndex(ict);
                    }
                }
                if (ss == null)
                {
                    switch (s[i]) //!#$
                    {
                        case '!': //location of last command
                            ss = myStack.GetLastCommand();
                            break;
                        case '#': //location of last number
                            ss = myStack.GetLastValue();
                            break;
                        case '$': //location of last adj number
                            ss = myStack.GetLastAdjValue();
                            break;
                    }
                }
                if (ss != null)
                {
                    if (multiAContext || multiRContext)
                        throw new ArgumentException("Incorrect ending to reference");
                    if (iteratorContext)
                    {
                        if (rangeContext)
                        {
                            rangeEnd = ss;
                            sri.refs.AddRange(GenerateRange(rangeStart, rangeEnd));
                            rangeContext = false;
                        }
                        else
                        {
                            sri.refs.Add(ss);
                        }
                    }
                    else
                    {
                        if (rangeContext)
                        {
                            rangeEnd = ss;
                            srl.AddRange(GenerateRange(rangeStart, rangeEnd));
                            rangeContext = false;
                        }
                        else
                        {
                            srl.Add(ss);
                        }
                    }
                }
                else
                {
                    irem = i;
                    break; //unknown character encountered
                }
            }
            if (multiAContext || multiRContext || iteratorContext)
                throw new ArgumentException("Incorrect range definition end");
            if (rangeContext)
            {
                rangeEnd = myStack.GetRefByRelativeIndex(1);
                srl.AddRange(GenerateRange(rangeStart, rangeEnd));
                rangeContext = false;
            }
            if (irem == -1)
            {
                return (srl, "");
            }
            else
            {
                return (srl, s.Substring(irem));
            }
        }

        private List<SRSingle> GenerateRange(SRSingle rangeStart, SRSingle rangeEnd)
        {
            int dj = (rangeEnd.stackIndex < rangeStart.stackIndex) ? -1 : 1;
            int ne = dj * (rangeEnd.stackIndex - rangeStart.stackIndex);
            int ds = rangeStart.stackIndex;
            List<SRSingle> srl = new List<SRSingle>();
            while (ne >= 0)
            {
                srl.Add(new SRSingle() { stackIndex = ds });
                ds += dj;
                ne--;
            }
            return srl;
        }

        public static EntryType TestInputStart(string s)
        {
            if (string.IsNullOrEmpty(s))
                return EntryType.Unknown;
            if (s[0] == comchar)
                return EntryType.Com;
            if (s[0] == dpchar)
                return EntryType.Num;
            if (char.IsAsciiLetterLower(s[0]))
                return EntryType.Cmd;
            if (char.IsAsciiLetterUpper(s[0]))
                return EntryType.Ref;
            if (rschars.Contains(s[0]))
                return EntryType.Ref;
            bool cnamb = nschars.Contains(s[0]);
            if (cschars.Contains(s[0]) && !cnamb)
                return EntryType.Cmd;
            bool rnamb = char.IsAsciiDigit(s[0]);
            if (!cnamb && !rnamb)
                return EntryType.Unknown;
            if (cnamb)
            {
                if (s.Length > 1 && (char.IsAsciiDigit(s[1]) || s[1] == dpchar))
                    return EntryType.Num;
                else
                    return EntryType.Cmd;
            }
            int ec = 0;
            for (int a=1; a<s.Length; a++)
            {
                if (ec == 1)
                {
                    if (nschars.Contains(s[a]))
                    {
                        ec = 2;
                        continue;
                    }
                    if (char.IsAsciiDigit(s[a]))
                        ec = 3;
                    else
                        return EntryType.Ref;
                }
                if(ec == 2)
                {
                    if (char.IsAsciiDigit(s[a]))
                        ec = 3;
                    else
                        return EntryType.Ref;
                }
                if (char.IsAsciiDigit(s[a]))
                    continue;
                if (s[a] == comchar || s[a] == dpchar)
                    break;
                if (ec == 0 && eechars.Contains(s[a]))
                {
                    ec = 1;
                    continue;
                }
                return EntryType.Ref;
            }
            return (ec==0 || ec==3) ? EntryType.Num : EntryType.Ref;
        }
    }
}
