void processSerial(){
  char a;
  static byte showcenter=0;
  if(Serial.available()){
    a=Serial.read();
    if(a=='S'){
      motor_auto_stop=false;//avoid stopping from ethernet disconnect when running by serial
      startDisplay(true);
    }
    if(a=='s'){
      startDisplay(false);
    }
    if(a=='o'){
      Serial.print(opt_state);
      Serial.print(',');
      Serial.print(err_slow);
      Serial.print(',');
      Serial.println(err_lock);
      Serial.print(opt1_el_min);
      Serial.print(',');
      Serial.print(opt1_el_max);
      Serial.print(',');
      Serial.print(opt1_dur_min);
      Serial.print(',');
      Serial.print(opt1_dur_max);
      Serial.println();
      Serial.print(opt2_el_min);
      Serial.print(',');
      Serial.print(opt2_el_max);
      Serial.print(',');
      Serial.print(opt2_dur_min);
      Serial.print(',');
      Serial.print(opt2_dur_max);
      Serial.println();
      for(int i=0; i<7; i++){
        Serial.println(c[i]);
      }
      opt1_el_min=1000000; opt1_el_max=0; opt1_dur_min=1000000; opt1_dur_max=0; opt2_el_min=1000000; opt2_el_max=0; opt2_dur_min=1000000; opt2_dur_max=0;
    }
    if(a=='p'){
      stopDisplay();
    }
    if(a=='v'){
      if(digitalRead(41)){
        Serial.println("External 5V available");
      }else{
        Serial.println("External 5V not available");
      }
      Serial.print("5V Supply Current [A] = ");
      Serial.println(ina_shunt_voltage(INA232_addr) / 0.03f); //current through 30 mohm sense resistor
      Serial.print("5V Supply Voltage [V] = ");
      Serial.println(ina_bus_voltage(INA232_addr));
    }
    if(a=='c'){
      if(adxl345_check(ADXL345_addr)){
        Serial.println("ADXL345 detected");
      }else{
        Serial.println("ADXL345 not detected");
      }
      if(ina232_check(INA232_addr)){
        Serial.println("INA232 detected");
      }else{
        Serial.println("INA232 not detected");
      }
    }
    if(a=='b'){
      adxl_ovr_errs=0;
      adxl_samples_acquired=0;
      for(int y=0;y<opt_edges_thetas;y++){
        adxl_samples[y]=0;
      }
      t_adxl_min=1000000; t_adxl_max=0;
      if(adxl345_start(ADXL345_addr)){
        Serial.println("ADXL started");
        delay(10);//wait for conversions to start
        adxl_running=true;
      }else{
        Serial.println("ADXL not started");
        adxl_running=false;
      }
    }
    if(a=='l'){
      adxl_num_avg=72368;
    }
    if(a=='k'){
      adxl_num_avg=1638;
    }
    if(a=='n'){
      adxl345_stop(ADXL345_addr);
      adxl_running=false;
      Serial.println("ADXL stopped");
      Serial.print("Total samples acquired: ");
      Serial.println(adxl_samples_acquired);
      Serial.print("Overrun errors: ");
      Serial.println(adxl_ovr_errs);
      Serial.print("Between samples min,max time: ");
      Serial.print(t_adxl_min);
      Serial.print(',');
      Serial.println(t_adxl_max);
      for(uint32_t n=0;n<opt_edges_thetas;n++){
        Serial.print(adxl_samples[n]);
        Serial.print(',');
      }
      Serial.println();
      for(uint32_t n=0;n<opt_edges_thetas;n++){
        Serial.print(vibx[n]);
        Serial.print(',');
      }
      Serial.println();
      for(uint32_t n=0;n<opt_edges_thetas;n++){
        Serial.print(viby[n]);
        Serial.print(',');
      }
      Serial.println();
      for(uint32_t n=0;n<opt_edges_thetas;n++){
        Serial.print(vibz[n]);
        Serial.print(',');
      }
      Serial.println();
    }
    if(a>='0' && a<='9'){
      setMotorLevel(a!='0', (a-'0')*28);
    }
    if(a=='w'){
      Serial.print("State=");
      Serial.print(opt_state);
      Serial.print(", RPS=");
      Serial.println(get_motor_speed());
    }
    if(a=='a'){
      test_ld_mode=(test_ld_mode+1)%3;
      generateTestPattern(260);
    }
    if(a=='+'){
      north_pixel_shift++;
      generateLaserBuffer();
      //test_ld=(test_ld+1)%256;
      //generateTestPattern(test_ld);
    }
    if(a=='-'){
      north_pixel_shift--;
      generateLaserBuffer();
      //test_ld=(test_ld-1)%256;
      //generateTestPattern(test_ld);
    }
    if(a=='A'){
      clearPixelBuffer();
      const int r[4]={6,50,100,124};
      for(int rc=0;rc<4;rc++){
        for(int cc=0;cc<512;cc++){
          setPixel(r[rc],cc,3);
        }
      }
      generateLaserBuffer();
    }
    if(a=='B'){
      clearPixelBuffer();
      const int c[4]={0,128,256,384};
      for(int rc=0;rc<128;rc++){
        for(int cc=0;cc<4;cc++){
          setPixel(rc,c[cc],3);
        }
      }
      generateLaserBuffer();
    }
    if(a=='C'){
      clearPixelBuffer();
      for(int rc=0;rc<(128-3);rc++){
        for(int cc=0;cc<512;cc++){
          setPixel(rc,cc,3);
        }
      }
      generateLaserBuffer();
    }
    if(a=='D'){
      clearLaserBuffer();
    }
    if(a=='Y'){
      //receive dots information
      int bytes=0;
      bytes=Serial.read();
      bytes<<=8;
      bytes|=Serial.read();
      clearPixelBuffer();
      int dots=(bytes*8)/18;
      int bo=0, bi=0;
      uint32_t dtd=0, dts=0;
      elapsedMillis els1=0;
      for(int bc=0; bc<bytes; bc++){
        if(!Serial.available()){
          delay(1);
          if(els1>1000)
            break;
        }
        dtd=(dtd<<8)|Serial.read();
        bi+=8;
        if(bi>=18){
          dts=dtd>>(bi-18);
          setPixel((dts>>2)&0x7F,dts>>9,dts&0x03);
          bi-=18;
        }
      }
      generateLaserBuffer();
    }
    if(a=='Z'){
      //receive full screen information
      int bytes=0;
      elapsedMillis els1=0;
      uint32_t dti=0;
      for(int bc=0; bc<16384; bc++){
        if(!Serial.available()){
          delay(1);
          if(els1>1000)
            break;
        }
        uint32_t si=Serial.read();
        si<<=24;
        for(int q=0; q<4; q++){
          dti>>=2;
          dti|=(si&0xC0000000);//lower columns end up as LSBs
          si<<=2;
        }
        if(bc%4==3){
          pixel_buffer[bc/4]=dti;
        }
      }
      generateLaserBuffer();
    }
    if(a=='.'){
      setDrawingMode(0);
    }
    if(a=='_'){
      setDrawingMode(2);
    }
    if(a=='*'){
      test_ld=(test_ld+1)%256;
      a='E'+showcenter;
    }
    if(a=='/'){
      test_ld=(test_ld-1)%256;
      a='E'+showcenter;
    }
    if(a=='E'){
      showcenter=0;
      clearPixelBuffer();
      for(int pc=0;pc<4;pc++){
        setPixel(0,(test_ld*2+pc*128)%512,3);
        setPixel(64,(test_ld*2+pc*128+64)%512,3);
        setPixel(63,(test_ld*2+pc*128+64+128)%512,3);
      }
      generateLaserBuffer();
    }
    if(a=='F'){
      showcenter=1;
      clearPixelBuffer();
      for(int pc=0;pc<4;pc++){
        setPixel(0,(test_ld*2+pc*128)%512,1);
        setPixel(64,(test_ld*2+pc*128+64)%512,3);
        setPixel(63,(test_ld*2+pc*128+64+128)%512,3);
      }
      setPixel(0,(210*2+0*128)%512,3);//reference LD
      generateLaserBuffer();
    }
    if(a=='G'){
      showcenter=2;
      clearPixelBuffer();
      for(int pc=0;pc<128;pc++){
        setPixel(pc,(test_ld*2+pc)%512,2);
        setPixel(pc,(test_ld*2+pc+1)%512,2);
        setPixel(pc,(test_ld*2+pc-1)%512,2);
        setPixel(127-pc,(test_ld*2+128+pc)%512,2);
        setPixel(127-pc,(test_ld*2+128+pc+1)%512,2);
        setPixel(127-pc,(test_ld*2+128+pc-1)%512,2);
      }
      generateLaserBuffer();
    }
    if(a==']'){
      theta_pixel_vshift+=10.0f;
    }
    if(a=='['){
      theta_pixel_vshift-=10.0f;
    }
    if(a=='{'){ theta_pixel_shift-=0.1f; } if(a=='}'){ theta_pixel_shift+=0.1f; }
    if(a=='('){ theta_pixel_shift-=0.01f; } if(a==')'){ theta_pixel_shift+=0.01f; }
    if(a=='P'){Serial.println(theta_pixel_shift);Serial.println(theta_pixel_vshift);}
  }
}
