//eeprom
const byte fmt_code=0xA0;//change this when changing the memory structure, do not use 0xFF as this is default

void loadFromEeprom(){
  byte d=eeprom_read_byte(0);
  if(d!=fmt_code) return; //memory has not been written or is not the correct format, don't change any values
  //memory has been written, load into variables
  //[2,3,4,5] IP Address, [6,7] server port
  //[8,9,10,11] theta pixel shift (fixed point x1024), [12,13,14,15] theta pixel vshift (fixed point x1024), [16,17] north pixel shift (0-512)
  //[18,19] theta_alpha [20,21] omega_alpha IIR coefficients for angular position and velocity (fixed point x32768), between 0 and 1, high value = averaging is preferred, low value = measurement is preferred
  //[23] default motor speed, [24] motor speed limit
  //[25] flags: 0x80 auto-start motor on startDisplay, 0x40 auto-stop motor on stopDisplay, 0x20 auto-start display on connection, 0x10 ethernet LED enable during display
  //            0x08|0x04 default bright mode (0 to 2), 0x02|0x01 dots "or" mode (only 0 or 1 for now)
  //[26] motor stop ethernet timeout in seconds, [27] ethernet command code burst under-range timeout in ms, [28] motor spin-up timeout error in seconds
  //optical edge clock
  //[30] TMR3.3 slow divider to match mirror RPM
  //delay cycles for timer0 .. timer7
  //[32] timer0 LSB, cycles per transition for retriggering pixel steps
  //[34,35] timer1 cycles to delay before reset
  //[36,37] timer2 cycles to delay before enable
  //[38,39] timer5 cycles to delay before latch
  //[40,41] timer7 cycles to delay during enable
  /*staticIP[0]=eeprom_read_byte(2);
  staticIP[1]=eeprom_read_byte(3);
  staticIP[2]=eeprom_read_byte(4);
  staticIP[3]=eeprom_read_byte(5);
  kServerPort=eeprom_read_word(6);*/
  int32_t ts;
  ts=eeprom_read_dword(8);
  theta_pixel_shift=ts*(1.0f/1024.0f);
  while(theta_pixel_shift>=256){
    theta_pixel_shift-=512;
  }
  while(theta_pixel_shift<-256){
    theta_pixel_shift+=512;
  }
  ts=eeprom_read_dword(12);
  theta_pixel_vshift=ts*(1.0f/1024.0f);
  if(theta_pixel_vshift>751){
    theta_pixel_vshift=751;
  }
  if(theta_pixel_vshift<-751){
    theta_pixel_vshift=-751;
  }
  north_pixel_shift=eeprom_read_word(16);
  ts=eeprom_read_word(18);
  theta_alpha=ts*(1.0f/32768.0f);
  if(theta_alpha>0.9999f){
    theta_alpha=0.9999f;
  }
  if(theta_alpha<0){
    theta_alpha=0;
  }
  ts=eeprom_read_word(20);
  omega_alpha=ts*(1.0f/32768.0f);
  if(omega_alpha>0.9999f){
    omega_alpha=0.9999f;
  }
  if(omega_alpha<0){
    omega_alpha=0;
  }
  motor_default_speed=eeprom_read_byte(23);
  /*motor_max_speed=eeprom_read_byte(24);
  uint8_t flags=eeprom_read_byte(25);
  motor_auto_start=(flags&0x80)!=0;
  motor_auto_stop=(flags&0x40)!=0;
  display_auto_start=(flags&0x20)!=0;
  eth_led_enable=(flags&0x10)!=0;
  bright_mode=(flags&0x0C)>>2;
  ds_or_mode=(flags&0x01)!=0;
  uint32_t ls;
  ls=eeprom_read_byte(26);
  disconnect_stopdisplay=ls*1000;
  cmd_burst_interval=eeprom_read_byte(27);
  ls=eeprom_read_byte(28);
  motor_spinup_time=ls*1000;
  tmr3_slow_div=eeprom_read_byte(30);
  pxt0lsb=eeprom_read_byte(32);
  pxt1dly=eeprom_read_word(34);
  pxt2dly=eeprom_read_word(36);
  pxt5dly=eeprom_read_word(38);
  pxt7dly=eeprom_read_word(40);*/
}

void writeToEeprom(){
  //check for identical values happens in the eeprom emulation functions so don't need to do it here
  /*eeprom_write_byte(2, staticIP[0]);
  eeprom_write_byte(3, staticIP[1]);
  eeprom_write_byte(4, staticIP[2]);
  eeprom_write_byte(5, staticIP[3]);
  eeprom_write_word(6, kServerPort);*/
  int32_t ts;
  ts=round(theta_pixel_shift*1024.0f);
  eeprom_write_dword(8, ts);
  ts=round(theta_pixel_vshift*1024.0f);
  eeprom_write_dword(12, ts);
  eeprom_write_word(16, north_pixel_shift);
  ts=round(theta_alpha*32768.0f);
  eeprom_write_word(18, (uint16_t)ts);
  ts=round(omega_alpha*32768.0f);
  eeprom_write_word(20, (uint16_t)ts);
  eeprom_write_byte(23, motor_default_speed);
  /*eeprom_write_byte(24, motor_max_speed);
  uint8_t flags=0;
  if(motor_auto_start) { flags|=0x80; }
  if(motor_auto_stop)  { flags|=0x40; }
  if(display_auto_start){ flags|=0x20; }
  if(eth_led_enable)   { flags|=0x10; }
  flags|=((bright_mode&0x03)<<2);
  if(ds_or_mode)       { flags|=0x01; }
  eeprom_write_byte(25, flags);
  uint32_t ls;
  ls=disconnect_stopdisplay/1000;
  eeprom_write_byte(26, ls>255?255:ls);
  ls=cmd_burst_interval;
  eeprom_write_byte(27, ls>255?255:ls);
  ls=motor_spinup_time/1000;
  eeprom_write_byte(28, ls>255?255:ls);
  eeprom_write_byte(30, tmr3_slow_div);
  eeprom_write_byte(32, pxt0lsb);
  eeprom_write_word(34, pxt1dly);
  eeprom_write_word(36, pxt2dly);
  eeprom_write_word(38, pxt5dly);
  eeprom_write_word(40, pxt7dly);*/
  eeprom_write_byte(0, fmt_code);//mark memory as written
}

void discardEeprom(){//mark memory as invalid, to use program defaults on next load
  eeprom_write_byte(0, 0xFF);
}

