void setMotorLevel(bool pwr, byte duty){
  if(duty>motor_max_speed){
    duty=motor_max_speed;
  }
  if(pwr==false){
    analogWrite(33, 0);
    pinMode(33, OUTPUT); //motor PWM disconnect from timer to achieve fully low output
    digitalWrite(33, LOW); //low output
    digitalWrite(39, LOW); //disable motor
  }else{
    digitalWrite(39, HIGH); //enable motor
    delay(1);
    if(duty==0){
      pinMode(33, OUTPUT); //motor PWM disconnect from timer to achieve fully low output
      digitalWrite(33, LOW); //low output
    }else{
      if(duty==255){
        pinMode(33, OUTPUT); //motor PWM disconnect from timer to achieve fully low output
        digitalWrite(33, HIGH); //high output
      }else{
        analogWriteFrequency(33, 25000);//25 kHz PWM output
        analogWrite(33, duty);//duty cycle
      }
    }
  }
}

//bool isMotorRunning(){ return digitalRead(39); }

void processADXL(){
  int dr=adxl345_dataready(ADXL345_addr);
  if(dr==0){
    return;
  }
  if(adxl_samples_acquired>5){
    if(el_adxl>t_adxl_max){
      t_adxl_max=el_adxl;
    }
    if(el_adxl<t_adxl_min){
      t_adxl_min=el_adxl;
    }
  }
  el_adxl=0;
  if(dr==2){
    adxl_ovr_errs++;
  }
  static int adxlbuf[3];
  adxl345_read(ADXL345_addr, adxlbuf);
  adxl_samples_acquired++;
  if(adxl_samples_acquired<2){
    zrmsref=adxlbuf[2];
  }
  if((opt_state==15)&&(adxl_samples_acquired>2)){
    uint32_t sv=ld_sync_var;
    uint16_t ct=TMR3_CNTR0;//most recent counter value so we can make updated estimate of position
    uint16_t ref_theta=(uint16_t)(((sv&0xFFFF)>>((16-opt_edges_cirs)+opt_edges_dec)));//reduced theta index
    uint32_t cc=(uint32_t)(sv&(0xFFFF>>(opt_edges_cirs-opt_edges_dec)));//timer ticks per reduced theta step
    uint16_t tref=(uint16_t)(sv>>16);//timer reference counter at reference theta
    uint16_t dt=ct-tref;//we expect to be forward of reference by this many ticks
    uint32_t cur_theta=ref_theta+(uint16_t)round(((float)dt)/((float)cc));//closest theta at moment of adxl data reading
    cur_theta%=opt_edges_thetas;//wrap around
    adxl_samples[cur_theta]++;
    float ad_alpha=1.0f-1.0f/adxl_samples[cur_theta];//linear averaging all samples
    vibx[cur_theta]=(vibx[cur_theta]*ad_alpha)+(adxlbuf[0]*(1-ad_alpha));
    viby[cur_theta]=(viby[cur_theta]*ad_alpha)+(adxlbuf[1]*(1-ad_alpha));
    vibz[cur_theta]=(vibz[cur_theta]*ad_alpha)+(adxlbuf[2]*(1-ad_alpha));
    int zr=adxlbuf[2]-zrmsref;//running RMS
    zrmslin+=zr;
    zrmssq+=(zr*zr);
    zrmsnum++;
  }
  if(adxl_samples_acquired>adxl_num_avg){
    //do analysis
    //find main sinusoidal component
    float sws=0, cws=0;
    for(int i=0; i<opt_edges_thetas; i++){
      sws+=(vibz[i]*siw[i]);
      cws+=(vibz[i]*cow[i]);
      if(i>0){
        Serial.print(',');
      }
      Serial.print(vibz[i]);
    }
    Serial.println();
    sws/=(opt_edges_thetas/2);
    cws/=(opt_edges_thetas/2);
    float mag=sqrt(sws*sws+cws*cws);
    float phs=atan2(sws,cws)*57.29578f;
    float srs=0, srss=0;
    for(int i=0; i<opt_edges_thetas; i++){
      float sdif=(vibz[i]-sws*siw[i]-cws*cow[i])/mag;
      srs+=sdif;
      srss+=sdif*sdif;
      adxl_samples[i]=0;
    }
    //std=sqrt(sum(d(i)^2)/N-sum(d(i))^2/N^2)=sqrt(sum(d(i)^2)/N-(sum(d(i))/N)^2)
    float sstd=sqrt(srss/opt_edges_thetas-pow(srs/opt_edges_thetas,2));
    Serial.print(mag);//magnitude
    Serial.print(',');
    Serial.print(phs);//phase
    Serial.print(',');
    Serial.print(1-sstd);//sinusoidality (1 = very sinusoidal, 0 and lower = not usefully sinusoidal)
    float zstd=sqrt(((float)zrmssq)/zrmsnum+pow(((float)zrmslin)/zrmsnum,2));
    Serial.print(',');
    Serial.println(zstd);//overall Z standard deviation / noise
    zrmssq=0; zrmslin=0; zrmsnum=0;
    adxl_samples_acquired=0; //restart averaging
  }
}

uint16_t i2c_read16(byte addr, byte reg){
  Wire.beginTransmission(addr);
  Wire.write(reg);
  if(Wire.endTransmission(false)){
    Wire.endTransmission();
    //Serial.println("I2C 16bit read fail");
    return 0;
  }
  Wire.requestFrom(addr, (byte)2);
  uint16_t ret=Wire.read();
  ret<<=8;
  ret|=Wire.read();
  return ret;
}

bool i2c_write16(byte addr, byte reg, uint16_t val){
  Wire.beginTransmission(addr);
  Wire.write(reg);
  byte val1;
  val1=(val>>8)&0xFF;
  Wire.write(val1);
  val1=val&0xFF;
  Wire.write(val1);
  bool r=(Wire.endTransmission() == 0);
  delay(1);
  return r;
}

uint8_t i2c_read8(byte addr, byte reg){
  Wire.beginTransmission(addr);
  Wire.write(reg);
  Wire.endTransmission(false);
  Wire.requestFrom(addr, (byte)1);
  return Wire.read();
}

bool i2c_write8(byte addr, byte reg, uint8_t val){
  Wire.beginTransmission(addr);
  Wire.write(reg);
  Wire.write(val);
  return (Wire.endTransmission() == 0);
}

bool ina232_check(byte ina_addr){
  return (i2c_read16(ina_addr, 0x3E)==0x5449); //check the Manufacturer ID register
}

bool ina232_start(byte ina_addr){
  //send a reset command
  i2c_write16(ina_addr, 0x00, 0xC000);
  delay(30);
  //set configuration for 128 averages, 4156 us conversion time (data ready every 532 ms), continuous mode
  return i2c_write16(ina_addr, 0x00, 0x49B7);
}

float ina_shunt_voltage(byte ina_addr){
  int vs = i2c_read16(ina_addr, 0x01);
  if(vs>=0x8000){
    vs-=0x10000; //convert to signed
  }
  return vs*2.5e-6f;
}

float ina_bus_voltage(byte ina_addr){
  int vs = i2c_read16(ina_addr, 0x02);
  return vs * 1.6e-3f;
}

bool adxl345_check(byte addr){
  return (i2c_read8(addr, 0x00)==0xE5);//check DEVID
}

bool adxl345_start(byte addr){
  //rt sets output data rate (bandwidth is half of this):
  //9=50 Hz, 10=100 Hz power-up default, 11=200 Hz (recommended max for 100 kHz I2C speed)
  //12=400 Hz, 13=800 Hz (recommended max for 400 kHz I2C speed)
  //rt=constrain(rt,9,11);
  int rt=12;
  i2c_write8(addr,0x2D,0x00);//enter standby mode
  i2c_write8(addr,0x2C,0x0F&rt);//set rate
  //i2c_write8(addr,0x31,0x00);//+-2g output
  int fifo_mode=0;//0=not used, 1=fill fifo (keep old entries), 2=overwrite fifo (keep new entries), 3=trigger
  i2c_write8(addr, 0x38,((fifo_mode&0x03)<<6)|31);//set FIFO mode
  delay(10);
  return i2c_write8(addr,0x2D,0x08); //enter Measurement mode
}

void adxl345_stop(byte addr){
  i2c_write8(addr,0x2D,0x00);//enter standby mode
}

int adxl345_dataready(byte addr){
  //return 0 for no data ready, 1 for data ready, 2 for overrun
  byte r=i2c_read8(addr, 0x30);//check INT_SOURCE, DATA_READY bit 7, Overrun bit 0
  if((r&0x01)!=0){
    return 2;
  }
  if((r&0x80)!=0){
    return 1;
  }
  return 0;
}

void adxl345_read(byte addr, int d[]){
  Wire.beginTransmission(addr);
  Wire.write(0x32);//DATAX,Y,Z
  Wire.endTransmission(false);
  Wire.requestFrom(addr, 6);
  int res1, res2;
  res1=Wire.read();
  res2=Wire.read();
  d[0]=((res2<<24)|(res1<<16))>>16;//hopefully arithmetic right shift
  res1=Wire.read();
  res2=Wire.read();
  d[1]=((res2<<24)|(res1<<16))>>16;//hopefully arithmetic right shift
  res1=Wire.read();
  res2=Wire.read();
  d[2]=((res2<<24)|(res1<<16))>>16;//hopefully arithmetic right shift
}
